/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest;

import dev.toma.gunsrpg.common.quests.condition.IQuestConditionProvider;
import dev.toma.gunsrpg.common.quests.quest.DisplayInfo;
import dev.toma.gunsrpg.common.quests.quest.IQuestData;
import dev.toma.gunsrpg.common.quests.quest.QuestConditionTierScheme;
import dev.toma.gunsrpg.common.quests.quest.QuestType;
import dev.toma.gunsrpg.common.quests.quest.QuestTypes;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;

public final class QuestScheme<D extends IQuestData> {
    private final ResourceLocation questId;
    private final QuestType<D, ?> questType;
    private final D data;
    private final int tier;
    private final boolean isSpecialTaskQuest;
    private final DisplayInfo displayInfo;
    private final IQuestConditionProvider<?>[] questConditions;
    private final QuestConditionTierScheme conditionTierScheme;

    public QuestScheme(ResourceLocation questId, QuestType<D, ?> questType, D data, int tier, boolean isSpecialTaskQuest, DisplayInfo displayInfo, IQuestConditionProvider<?>[] questConditions, QuestConditionTierScheme conditionTierScheme) {
        this.questId = questId;
        this.questType = questType;
        this.data = data;
        this.tier = tier;
        this.isSpecialTaskQuest = isSpecialTaskQuest;
        this.displayInfo = displayInfo;
        this.questConditions = questConditions;
        this.conditionTierScheme = conditionTierScheme;
    }

    public static <D extends IQuestData> QuestScheme<D> read(CompoundNBT nbt) {
        ResourceLocation questId = new ResourceLocation(nbt.func_74779_i("questId"));
        ResourceLocation questTypeId = new ResourceLocation(nbt.func_74779_i("questType"));
        QuestType questType = QuestTypes.getTypeById(questTypeId);
        String name = nbt.func_74779_i("data.name");
        String info = nbt.func_74779_i("data.info");
        Object data = questType.readData(nbt.func_74775_l("questData"));
        int tier = nbt.func_74762_e("tier");
        boolean isSpecialTask = nbt.func_74767_n("special");
        DisplayInfo displayInfo = new DisplayInfo(name, info);
        return new QuestScheme(questId, questType, data, tier, isSpecialTask, displayInfo, new IQuestConditionProvider[0], QuestConditionTierScheme.EMPTY_SCHEME);
    }

    public ResourceLocation getQuestId() {
        return this.questId;
    }

    public QuestType<D, ?> getQuestType() {
        return this.questType;
    }

    public D getData() {
        return this.data;
    }

    public int getTier() {
        return this.tier;
    }

    public boolean isSpecialTaskQuest() {
        return this.isSpecialTaskQuest;
    }

    public DisplayInfo getDisplayInfo() {
        return this.displayInfo;
    }

    public IQuestConditionProvider<?>[] getQuestConditions() {
        return this.questConditions;
    }

    public QuestConditionTierScheme getConditionTierScheme() {
        return this.conditionTierScheme;
    }

    public CompoundNBT serialize() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("questId", this.questId.toString());
        nbt.func_74778_a("questType", this.questType.getId().toString());
        nbt.func_74778_a("data.name", this.displayInfo.getName().getString());
        nbt.func_74778_a("data.info", this.displayInfo.getInfo().getString());
        nbt.func_74768_a("tier", this.tier);
        nbt.func_74757_a("special", this.isSpecialTaskQuest);
        nbt.func_218657_a("questData", (INBT)this.questType.writeData(this.data));
        return nbt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuestScheme that = (QuestScheme)o;
        return this.getQuestId().equals((Object)that.getQuestId());
    }

    public int hashCode() {
        return this.getQuestId().hashCode();
    }
}

